Attribute VB_Name = "modDatabase"
Option Explicit

Private Database As New clsDatabase

Public Masters()    As String

Public G_DB()       As Group_DB
Private Type Group_DB
    Group_Name      As String
    FILETIME        As Long
    Channel         As String
    Added_By        As String
    Access          As Long
    Ban_Message     As String
End Type

Public U_DB()       As User_DB
Private Type User_DB
    Username        As String
    FILETIME        As Long
    Channel         As String
    Added_By        As String
    Access          As String
    Ban_Message     As String
End Type

Enum DB_Types
    Group
    Master
    User
End Enum

Public Sub Reset_DB(ByVal Reset_Masters As Boolean, ByVal Load_DB As Boolean)
ReDim U_DB(0)
ReDim G_DB(0)
If Reset_Masters = True Then ReDim Masters(0)
If Load_DB = True Then Database.Load_Database
End Sub

Public Sub Save_DB()
Database.SaveDatabase
End Sub


Public Function Index_DB(ByVal strName As String, ByVal eType As DB_Types) As Integer
Dim i As Integer
Select Case eType
    Case Group
        For i = 0 To UBound(G_DB) - 1
            If StrComp(strName, G_DB(i).Group_Name, vbTextCompare) = 0 Then
                Index_DB = i
                Exit Function
            End If
        Next i
    Case Master
        For i = 0 To UBound(Masters) - 1
            If StrComp(strName, Masters(i), vbTextCompare) = 0 Then
                Index_DB = i
                Exit Function
            End If
        Next i
    Case User
        For i = 0 To UBound(U_DB) - 1
            If StrComp(strName, U_DB(i).Username, vbTextCompare) = 0 Then
                Index_DB = i
                Exit Function
            End If
        Next i
End Select
Index_DB = -1
End Function

Public Function Get_Flags(ByVal Name As String, ByVal DB_Type As DB_Types) As Long 'Non Wildcarded
    Dim i As Integer
    Select Case DB_Type
        Case User, Master
            For i = 0 To UBound(Masters) - 1
                If StrComp(Name, Masters(i), vbTextCompare) = 0 Then
                    Get_Flags = ConvertAccess("ACMODTISL")
                    Exit Function
                End If
            Next i
            
            For i = 0 To UBound(U_DB) - 1
                If StrComp(Name, U_DB(i).Username, vbTextCompare) = 0 Then
                    If Index_DB(U_DB(i).Access, Group) = -1 Then
                        Get_Flags = U_DB(i).Access
                    Else
                        Get_Flags = Get_Flags(U_DB(i).Access, Group)
                    End If
                End If
            Next i
        
        Case Group
            For i = 0 To UBound(G_DB) - 1
                If StrComp(Name, G_DB(i).Group_Name, vbTextCompare) = 0 Then
                    Get_Flags = G_DB(i).Access
                    Exit For
                End If
            Next i
        Case Else
            Get_Flags = 0
    End Select
End Function


Public Function Flag_DB(ByVal Name As String, ByVal DB_Type As DB_Types) As Long
Dim i As Integer

If Options.AutoAddToggle = True Then
    Name = Replace(LCase(Name), "@useast.battle.net", vbNullString)
    Name = Replace(LCase(Name), "@useast", vbNullString)
    Name = Replace(LCase(Name), "@uswest.battle.net", vbNullString)
    Name = Replace(LCase(Name), "@uswest", vbNullString)
    Name = Replace(LCase(Name), "@asia.battle.net", vbNullString)
    Name = Replace(LCase(Name), "@asia", vbNullString)
    Name = Replace(LCase(Name), "@europe.battle.net", vbNullString)
    Name = Replace(LCase(Name), "@europe", vbNullString)
    Name = Replace(LCase(Name), "@lordaeron", vbNullString)
    Name = Replace(LCase(Name), "@azeroth", vbNullString)
    Name = Replace(LCase(Name), "@highlander", vbNullString)
    Name = Replace(LCase(Name), "@northrend", vbNullString)
    Name = Replace(LCase(Name), "@westfall", vbNullString)
End If

Select Case DB_Type
    Case Master, User
        For i = 0 To UBound(Masters) - 1
            If matches(Masters(i), Name) = True Then Flag_DB = ConvertAccess("ACMODTISL"): Exit Function
        Next i
        
        For i = 0 To UBound(U_DB) - 1
            If matches(Name, U_DB(i).Username) = True Then
                If Index_DB(U_DB(i).Access, Group) = -1 Then
                    Flag_DB = U_DB(i).Access
                Else
                    Flag_DB = Flag_DB(U_DB(i).Access, Group)
                End If
            End If
        Next i
        
    Case Group
        For i = 0 To UBound(G_DB) - 1
            If StrComp(Name, G_DB(i).Group_Name, vbTextCompare) = 0 Then Flag_DB = G_DB(i).Access: Exit Function
        Next i
End Select
End Function

Public Function ReconvertAccess(ByVal Access As Long) As String
    If (Access And DB_Flag_A) = DB_Flag_A Then ReconvertAccess = ReconvertAccess & Chr(65)
    If (Access And DB_Flag_C) = DB_Flag_C Then ReconvertAccess = ReconvertAccess & Chr(67)
    If (Access And DB_Flag_M) = DB_Flag_M Then ReconvertAccess = ReconvertAccess & Chr(77)
    If (Access And DB_Flag_O) = DB_Flag_O Then ReconvertAccess = ReconvertAccess & Chr(79)
    If (Access And DB_Flag_D) = DB_Flag_D Then ReconvertAccess = ReconvertAccess & Chr(68)
    If (Access And DB_Flag_T) = DB_Flag_T Then ReconvertAccess = ReconvertAccess & Chr(84)
    If (Access And DB_Flag_I) = DB_Flag_I Then ReconvertAccess = ReconvertAccess & Chr(73)
    If (Access And DB_Flag_S) = DB_Flag_S Then ReconvertAccess = ReconvertAccess & Chr(83)
    If (Access And DB_Flag_F) = DB_Flag_F Then ReconvertAccess = ReconvertAccess & Chr(70)
    If (Access And DB_Flag_R) = DB_Flag_R Then ReconvertAccess = ReconvertAccess & Chr(82)
    If (Access And DB_Flag_L) = DB_Flag_L Then ReconvertAccess = ReconvertAccess & Chr(76)
    If (Access And DB_Flag_B) = DB_Flag_B Then ReconvertAccess = ReconvertAccess & Chr(66)
    If (Access And DB_Flag_P) = DB_Flag_P Then ReconvertAccess = ReconvertAccess & Chr(80)
    If (Access And DB_Flag_K) = DB_Flag_K Then ReconvertAccess = ReconvertAccess & Chr(75)
End Function

Public Function ConvertAccess(ByVal Access As String) As Long
Dim i As Integer
'ACMODNTIS F RL BPK
Access = UCase(Access)
If InStr(Access, Chr(65)) Then ConvertAccess = ConvertAccess Or DB_Flag_A
If InStr(Access, Chr(67)) Then ConvertAccess = ConvertAccess Or DB_Flag_C
If InStr(Access, Chr(77)) Then ConvertAccess = ConvertAccess Or DB_Flag_M
If InStr(Access, Chr(79)) Then ConvertAccess = ConvertAccess Or DB_Flag_O
If InStr(Access, Chr(68)) Then ConvertAccess = ConvertAccess Or DB_Flag_D
If InStr(Access, Chr(84)) Then ConvertAccess = ConvertAccess Or DB_Flag_T
If InStr(Access, Chr(73)) Then ConvertAccess = ConvertAccess Or DB_Flag_I
If InStr(Access, Chr(83)) Then ConvertAccess = ConvertAccess Or DB_Flag_S
If InStr(Access, Chr(70)) Then ConvertAccess = ConvertAccess Or DB_Flag_F
If InStr(Access, Chr(82)) Then ConvertAccess = ConvertAccess Or DB_Flag_R
If InStr(Access, Chr(76)) Then ConvertAccess = ConvertAccess Or DB_Flag_L
If InStr(Access, Chr(66)) Then ConvertAccess = ConvertAccess Or DB_Flag_B
If InStr(Access, Chr(80)) Then ConvertAccess = ConvertAccess Or DB_Flag_P
If InStr(Access, Chr(75)) Then ConvertAccess = ConvertAccess Or DB_Flag_K
End Function

Public Sub Add_B_Flag(ByVal Username As String, ByVal Added_User As String, Optional ByVal Ban_Message As String)
If CheckFlags(Username, True) = False Then
    If Index_DB(Username, User) <> -1 Then
        Call Database.Set_DB(Username, Added_User, (Get_Flags(Username, User) Or DB_Flag_B), User, Ban_Message)
    Else
        Call Database.Set_DB(Username, Added_User, DB_Flag_B, User, Ban_Message)
    End If
End If
End Sub

Public Function Get_Real_Name(ByVal Name As String, ByVal DB_Type As DB_Types) As String
Dim i As Integer
Select Case DB_Type
    Case Master, User
        For i = 0 To UBound(Masters) - 1
            If StrComp(Masters(i), Name, vbTextCompare) = 0 Then Get_Real_Name = Masters(i): Exit Function
        Next i
        
        For i = 0 To UBound(U_DB) - 1
            If StrComp(Name, U_DB(i).Username, vbTextCompare) = 0 Then
                Get_Real_Name = U_DB(i).Username
            End If
        Next i
        
    Case Group
        For i = 0 To UBound(G_DB) - 1
            If StrComp(Name, G_DB(i).Group_Name, vbTextCompare) = 0 Then Get_Real_Name = G_DB(i).Group_Name: Exit Function
        Next i
End Select
End Function

Public Function Get_Comment(ByVal Name As String, ByVal DB_Type As DB_Types) As String
Dim i As Integer
Select Case DB_Type
    Case Master, User
        For i = 0 To UBound(Masters) - 1
            If StrComp(Masters(i), Name, vbTextCompare) = 0 Then Get_Comment = vbNullString: Exit Function
        Next i
        
        For i = 0 To UBound(U_DB) - 1
            If StrComp(Name, U_DB(i).Username, vbTextCompare) = 0 Then
                Get_Comment = U_DB(i).Ban_Message
            End If
        Next i
        
    Case Group
        For i = 0 To UBound(G_DB) - 1
            If StrComp(Name, G_DB(i).Group_Name, vbTextCompare) = 0 Then Get_Comment = G_DB(i).Ban_Message: Exit Function
        Next i
End Select
End Function


Public Function Add_Flags(ByVal Username As String, ByVal Flags As String, ByVal Added_User As String, ByVal e_Type As DB_Types, ByVal strComment As String) As Boolean
Dim lngFlags As Long
'Debug.Print "Flags (string value): " & Flags
lngFlags = ConvertAccess(Flags)

If Index_DB(Username, Master) <> -1 Then
    Add_Flags = False
    Exit Function
End If

If Index_DB(Flags, Group) <> -1 And e_Type = User And Left$(LCase$(Flags), 4) = "grp_" Then
    lngFlags = Get_Flags(Flags, Group)
    If (((Get_Flags(Username, User) And DB_Flag_L) = DB_Flag_L) And (Flag_DB(Added_User, User) And DB_Flag_A = DB_Flag_A)) Or (Get_Flags(Username, User) And DB_Flag_L) <> DB_Flag_L Then
        If ((Flag_DB(Added_User, User) And DB_Flag_R) = DB_Flag_R) And ((Flag_DB(Added_User, User) And DB_Flag_D) <> DB_Flag_D) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            'Debug.Print "Before 'R' strip: " & ReconvertAccess(lngFlags)
            lngFlags = Strip_R_Flags(lngFlags)
        End If
        If ((lngFlags And DB_Flag_A) = DB_Flag_A) And (Flag_DB(Added_User, User) And DB_Flag_A <> DB_Flag_A) Then
            lngFlags = lngFlags Xor DB_Flag_A
        End If
        
        'Adding to group procedure:
        If Get_Flags(Flags, Group) = lngFlags Then 'Flags of group match tested flags of the group
            If Database.Group_User_Add(Username, Added_User, Get_Real_Name(Flags, Group), strComment) = True Then
                Add_Flags = True
            End If
        End If
    End If
    
ElseIf lngFlags <> 0 Then
    'Restrictions:
    If (((Get_Flags(Username, User) And DB_Flag_L) = DB_Flag_L) And (Flag_DB(Added_User, User) And DB_Flag_A = DB_Flag_A)) Or (Get_Flags(Username, User) And DB_Flag_L) <> DB_Flag_L Then
        If ((Flag_DB(Added_User, User) And DB_Flag_R) = DB_Flag_R) And ((Flag_DB(Added_User, User) And DB_Flag_D) <> DB_Flag_D) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            'Debug.Print "Before 'R' strip: " & ReconvertAccess(lngFlags)
            lngFlags = Strip_R_Flags(lngFlags)
        End If
        If ((lngFlags And DB_Flag_A) = DB_Flag_A) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            lngFlags = lngFlags Xor DB_Flag_A
        End If
        
        'Adding the flags procedure:
        'Debug.Print "Flags (to be added): " & ReconvertAccess(lngFlags)
        'Debug.Print "Before: " & ReconvertAccess(Get_Flags(Username, User))
        Select Case e_Type
            Case User
                If Database.Set_DB(Username, Added_User, Get_Flags(Username, User) Or lngFlags, User, strComment) = True Then
                    'Debug.Print "After: " & ReconvertAccess(Get_Flags(Username, User))
                    Add_Flags = True
                    If (lngFlags And DB_Flag_B) = DB_Flag_B Or (lngFlags And DB_Flag_P) = DB_Flag_P Or (lngFlags And DB_Flag_K) = DB_Flag_K Then
                        Call ChannelCheck_UL
                    End If
                End If
            Case Group
                If Database.Set_DB(Username, Added_User, Get_Flags(Username, Group) Or lngFlags, Group, strComment) = True Then
                    Add_Flags = True
                    If (lngFlags And DB_Flag_B) = DB_Flag_B Or (lngFlags And DB_Flag_P) = DB_Flag_P Or (lngFlags And DB_Flag_K) = DB_Flag_K Then
                        Call ChannelCheck_UL
                    End If
                End If
        End Select
    End If
End If
End Function

Public Function Rem_Flags(ByVal Username As String, ByVal Flags As String, ByVal Added_User As String, ByVal e_Type As DB_Types, ByVal strComment As String) As Boolean
Dim lngFlags As Long
lngFlags = ConvertAccess(Flags)

If Index_DB(Username, Master) <> -1 Then
    Rem_Flags = False
    Exit Function
End If

If Index_DB(Flags, Group) <> -1 And e_Type = User And Index_DB(Username, User) <> -1 And Left$(LCase$(Flags), 4) = "grp_" Then
    lngFlags = Get_Flags(Flags, Group)
    'Debug.Print "Rem_Flags(1): " & ReconvertAccess(lngFlags)
    If (((Get_Flags(Username, User) And DB_Flag_L) = DB_Flag_L) And (Flag_DB(Added_User, User) And DB_Flag_A = DB_Flag_A)) Or (Get_Flags(Username, User) And DB_Flag_L) <> DB_Flag_L Then
        If ((Flag_DB(Added_User, User) And DB_Flag_R) = DB_Flag_R) And ((Flag_DB(Added_User, User) And DB_Flag_D) <> DB_Flag_D) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            lngFlags = Strip_R_Flags(lngFlags)
        End If
        If ((lngFlags And DB_Flag_A) = DB_Flag_A) And (Flag_DB(Added_User, User) And DB_Flag_A <> DB_Flag_A) Then
            lngFlags = lngFlags Xor DB_Flag_A
        End If
        'Debug.Print "Rem_Flags(2): " & ReconvertAccess(lngFlags)
        'Deleting user:
        If Get_Flags(Flags, Group) = lngFlags And Index_DB(Username, User) > -1 Then 'Flags of group match tested flags of the group
            If Database.Delete_DB(Index_DB(Username, User), User) = True Then
                Rem_Flags = True
            End If
        End If
    End If
    
ElseIf lngFlags <> 0 And Index_DB(Username, e_Type) > -1 Then
    'Restrictions:
    If (((Get_Flags(Username, User) And DB_Flag_L) = DB_Flag_L) And (Flag_DB(Added_User, User) And DB_Flag_A = DB_Flag_A)) Or (Get_Flags(Username, User) And DB_Flag_L) <> DB_Flag_L Then
        If ((Flag_DB(Added_User, User) And DB_Flag_R) = DB_Flag_R) And ((Flag_DB(Added_User, User) And DB_Flag_D) <> DB_Flag_D) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            lngFlags = Strip_R_Flags(lngFlags)
        End If
        If ((lngFlags And DB_Flag_A) = DB_Flag_A) And ((Flag_DB(Added_User, User) And DB_Flag_A) <> DB_Flag_A) Then
            lngFlags = lngFlags Xor DB_Flag_A
        End If
        lngFlags = Strip_Flags(Username, e_Type, lngFlags)
        
        'Removing the flags procedure:
        Select Case e_Type
            Case User
                If Database.Set_DB(Username, Added_User, (Get_Flags(Username, User) Xor lngFlags), User, strComment) = True Then
                    Rem_Flags = True
                    Call ChannelCheck_UL
                End If
            Case Group
                'Debug.Print "Rem_Flags: Group"
                If Database.Set_DB(Username, Added_User, (Get_Flags(Username, Group) Xor lngFlags), Group, strComment) = True Then
                    Rem_Flags = True
                    Call ChannelCheck_UL
                End If
        End Select
    End If
End If
End Function

Public Function Strip_R_Flags(ByVal Flags As Long) As Long
    'R - Restricted Access Control (Un-Available flags: ACMD RL)
    If (Flags And DB_Flag_A) = DB_Flag_A Then Flags = Flags Xor DB_Flag_A
    If (Flags And DB_Flag_C) = DB_Flag_C Then Flags = Flags Xor DB_Flag_C
    If (Flags And DB_Flag_M) = DB_Flag_M Then Flags = Flags Xor DB_Flag_M
    If (Flags And DB_Flag_D) = DB_Flag_D Then Flags = Flags Xor DB_Flag_D
    If (Flags And DB_Flag_R) = DB_Flag_R Then Flags = Flags Xor DB_Flag_R
    If (Flags And DB_Flag_L) = DB_Flag_L Then Flags = Flags Xor DB_Flag_L
    Strip_R_Flags = Flags
End Function

Public Function Strip_Flags(ByVal Name As String, ByVal eType As DB_Types, ByVal Flags As Long) As Long 'Strips flags the user doesn't have with user attempting to be removed.
'ACMODTIS F RL BPK
 Dim tmp_Flags As Long
 tmp_Flags = Get_Flags(Name, eType)
 If ((tmp_Flags And DB_Flag_A) <> DB_Flag_A) And (Flags And DB_Flag_A) = DB_Flag_A Then Flags = Flags Xor DB_Flag_A
 If ((tmp_Flags And DB_Flag_C) <> DB_Flag_C) And (Flags And DB_Flag_C) = DB_Flag_C Then Flags = Flags Xor DB_Flag_C
 If ((tmp_Flags And DB_Flag_M) <> DB_Flag_M) And (Flags And DB_Flag_M) = DB_Flag_M Then Flags = Flags Xor DB_Flag_M
 If ((tmp_Flags And DB_Flag_O) <> DB_Flag_O) And (Flags And DB_Flag_O) = DB_Flag_O Then Flags = Flags Xor DB_Flag_O
 If ((tmp_Flags And DB_Flag_D) <> DB_Flag_D) And (Flags And DB_Flag_D) = DB_Flag_D Then Flags = Flags Xor DB_Flag_D
 If ((tmp_Flags And DB_Flag_T) <> DB_Flag_T) And (Flags And DB_Flag_T) = DB_Flag_T Then Flags = Flags Xor DB_Flag_T
 If ((tmp_Flags And DB_Flag_I) <> DB_Flag_I) And (Flags And DB_Flag_I) = DB_Flag_I Then Flags = Flags Xor DB_Flag_I
 If ((tmp_Flags And DB_Flag_S) <> DB_Flag_S) And (Flags And DB_Flag_S) = DB_Flag_S Then Flags = Flags Xor DB_Flag_S
 If ((tmp_Flags And DB_Flag_F) <> DB_Flag_F) And (Flags And DB_Flag_F) = DB_Flag_F Then Flags = Flags Xor DB_Flag_F
 If ((tmp_Flags And DB_Flag_R) <> DB_Flag_R) And (Flags And DB_Flag_R) = DB_Flag_R Then Flags = Flags Xor DB_Flag_R
 If ((tmp_Flags And DB_Flag_L) <> DB_Flag_L) And (Flags And DB_Flag_L) = DB_Flag_L Then Flags = Flags Xor DB_Flag_L
 If ((tmp_Flags And DB_Flag_B) <> DB_Flag_B) And (Flags And DB_Flag_B) = DB_Flag_B Then Flags = Flags Xor DB_Flag_B
 If ((tmp_Flags And DB_Flag_P) <> DB_Flag_P) And (Flags And DB_Flag_P) = DB_Flag_P Then Flags = Flags Xor DB_Flag_P
 If ((tmp_Flags And DB_Flag_K) <> DB_Flag_K) And (Flags And DB_Flag_K) = DB_Flag_K Then Flags = Flags Xor DB_Flag_K
 Strip_Flags = Flags
End Function
